#COMMENTS-START
PAC Compiler was written by maroesjk (nickname of Ren Dijkmans)
Please see the 'readme.pdf' file for general and/or copyright information

Package version:				0972 beta
Last changes in this script:	10 July 2008
#COMMENTS-END

#NoTrayIcon
Global	$FileList[4] = [3, '\aut2exe.exe', '\autoitsc.bin', '\upx.exe'], $Line = 1, $FilesFolder = @ScriptDir & '\app\appfiles', $PAC = @ScriptDir & '\other\source\Portable App Creator.au3', $PAC_with_CompileVersion = StringReplace($PAC, '.au3', ' with compileversion.au3'), $Script = FileRead($PAC), $Start = StringInStr($Script, '$CompileVersion' & @TAB & '= ')

FileInstall			('..\..\app\appfiles\picture.jpg',	'app\appfiles\picture.jpg')
FileInstall			('..\..\app\appfiles\line.jpg',		'app\appfiles\line.jpg')
GUICreate			('PAC Compiler', 442, 298, (@DesktopWidth - 442) / 2, (@DesktopHeight - 298) / 2 - 20)
GUICtrlCreatePic	('app\appfiles\line.jpg',	  0, 250, 442,   2)
GUICtrlCreatePic	('app\appfiles\picture.jpg', 0,   0, 132, 250)
GUISetIcon			('app\appinfo\gui.ico')
GUISetState()
LocateFiles()
Download()

Func CheckFiles($Folder)
	For $i = 1 to $FileList[0]
		If $Folder										Then FileCopy($Folder & $FileList[$i], $FilesFolder & '\', 1)
		If Not FileExists($FilesFolder & $FileList[$i])	Then Return
	Next
	GUICtrlCreateLabel(@CRLF & 'Found the AutoIt-files.' & @CRLF & 'Compiling and compressing Portable App Creator.', 150, 13 * Line(4), 280, 39)
	FileWrite($PAC_with_CompileVersion, StringReplace($Script, '|VERSION|', StringReplace(FileReadLine($PAC, 5), 'Package version:' & @TAB & @TAB & @TAB & @TAB, '')))
	ShellExecuteWait($FilesFolder & '\aut2exe.exe',	'/in "' & $PAC_with_CompileVersion & '" /out "' & @ScriptDir & '\Portable App Creator.exe" /icon "' & @ScriptDir & '\app\appinfo\portable app creator.ico" /comp 4')
	GUICtrlCreateLabel				('Done.', 150, 13 * Line(0), 280, 13)
	$Done	= GUICtrlCreateButton	('Done',  357, 262, 73, 23, 0)
	GUICtrlSetState					($Done,   320)
	While 1
		$Control = GUIGetMsg()
		If $Control = -3 or $Control = $Done Then Exit
	WEnd
EndFunc

Func LocateFiles()
	GUICtrlCreateLabel('Searching for the AutoIt-files in the files folder.',		150, 13 * Line(1), 280, 13)
	CheckFiles(False)
	GUICtrlCreateLabel('Searching the AutoIt-files in an AutoIt-installation.',		150, 13 * Line(1), 280, 13)
	CheckFiles(@ProgramFilesDir & '\AutoIt3\aut2exe')
	CheckFiles(RegRead('HKLM\Software\AutoIt v3\AutoIt', 'InstallDir') & '\aut2exe')
	GUICtrlCreateLabel('Searching for the AutoIt-files on any fixed drive.',		150, 13 * Line(1), 280, 13)
	$FixedDrives= DriveGetDrive('fixed')
	$SearchText	= GUICtrlCreateLabel('', 150, 13 * Line(0), 280, 13)
	For $Drive 	= 1 to $FixedDrives[0]
		GUICtrlSetData($SearchText, @TAB & 'Searching on drive ' & StringUpper($FixedDrives[$Drive]))
		$PID	= Run(@ComSpec & ' /c dir /b /s ' & $FixedDrives[$Drive] & $FileList[1], @SystemDir, @SW_HIDE, 6)
		While 1
			$Item	= StdOutRead($PID)
			If @Error Then ContinueLoop(2)
			If $Item Then
				GUICtrlSetData($SearchText, '')
				CheckFiles(StringReplace(StringReplace($Item, $FileList[1], ''), @CRLF, ''))
			EndIf
		WEnd
	Next
	GUICtrlDelete($SearchText)
	GUICtrlCreateLabel(@CRLF & 'The AutoIt-files were not found on your computer.', 150, 13 * Line(3), 280, 26)
EndFunc

Func Download()
	Local $AutoItEXE = 'autoit-v3-sfx.exe', $AutoItEXELocation	= 'http://www.autoitscript.com/cgi-bin/getfile.pl?autoit3/' & $AutoItEXE, $AutoItEXESize = Round(InetGetSize($AutoItEXELocation)/1024, 0)
	GUICtrlCreateLabel('Do you wish to download ' & $AutoItEXE & ' (' & $AutoItEXESize & ' kB) from the AutoIt website now?', 150, 13 * Line(3), 280, 26)
	$Yes 				= GUICtrlCreateButton	('&Yes',	283, 262, 73, 23, 0)
	$No 				= GUICtrlCreateButton	('&No',		357, 262, 73, 23, 0)
						  GUICtrlSetState		($Yes,	320)
	While 1
		$Control = GUIGetMsg()
		If $Control = -3	Then Exit
		If $Control = $No	Then ExitLoop
		If $Control = $Yes	Then
			GUICtrlSetData($No, 'Cancel')
			GUICtrlDelete($Yes)
			$ProgressBar	= GUICtrlCreateProgress	(	 150, 13 * Line(1), 280, 13)
			$ProgressText	= GUICtrlCreateLabel	('', 150, 13 * Line(1), 280, 13, 1)
			InetGet($AutoItEXELocation, $FilesFolder & '\' & $AutoItEXE, 0, 1)
			While @InetGetActive
				$Control = GUIGetMsg()
				If $Control = -3	Then Exit
				If $Control = $No	Then ExitLoop(2)
				$InetkBytesRead	= Sleep(500) * Round(@InetGetBytesRead/1024, 0)
				GUICtrlSetData($ProgressBar,	$InetkBytesRead/$AutoItEXESize * 100)
				GUICtrlSetData($ProgressText,	'downloading ' & $AutoItEXE & ' (' & $InetkBytesRead & ' kB of ' & $AutoItEXESize & ' kB done).')
			Wend
			GUICtrlDelete($No)
			GUICtrlSetData($ProgressText,	'Download complete. Extracting the required files.')
			ShellExecuteWait($FilesFolder & '\' & $AutoItEXE, ' -s', $FilesFolder)
			GUICtrlDelete($ProgressText)
			ExitLoop
		EndIf
	WEnd
	GUICtrlDelete($No)
	GUICtrlDelete($Yes)
	Line(-1)
	CheckFiles($FilesFolder & '\install\aut2exe')
	GUICtrlCreateLabel(@CRLF & 'The required AutoIt files do not exist or are incorrectly located. Please see the readme-file supplied with this package.', 150, 13 * Line(0), 280, 52)
	$Exit	= GUICtrlCreateButton	('Exit', 357, 262, 73, 23, 0)
			  GUICtrlSetState		($Exit, 320)
	While 1
		$Control = GUIGetMsg()
		If $Control = -3 or $Control = $Exit Then Exit
	WEnd
EndFunc

Func Line($Add)
	$Line += $Add
	Return $Line - $Add
EndFunc

Func OnAutoItExit()
	DirRemove($FilesFolder & '\install', 1)
	FileDelete($PAC_with_CompileVersion)
	If FileExists(@ScriptDir & '\Portable App Creator.exe') Then
		IniWrite(@ScriptDir & '\App\AppInfo\AppInfo.ini', 'Control', 'Start', 'Portable App Creator.exe')
		Run(@ScriptDir & '\Portable App Creator.exe')
	EndIf
EndFunc